% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{applyMagneticDeclination}
\alias{applyMagneticDeclination}
\title{Alter an object to account for magnetic declination}
\usage{
applyMagneticDeclination(object = "oce", declination = "ANY", debug = "ANY")
}
\arguments{
\item{object}{an object of \linkS4class{cm}, \linkS4class{adp}, or \linkS4class{adv} class.}

\item{declination}{numeric value holding magnetic declination in degrees,
positive for clockwise from north.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
an object of the same class as \code{object}, modified as described
in \sQuote{Details}.
}
\description{
Current-measuring instruments that infer flow direction using magnetic
compasses require a correction for magnetic declination, in order to infer
currents with x and y oriented eastward and northward, respectively.
\code{\link[=applyMagneticDeclination]{applyMagneticDeclination()}} is a generic function that handles this task by
altering velocity components (and heading values, if they exist).  It works
for objects of the \linkS4class{cm}, \linkS4class{adp} and \linkS4class{adv} and \linkS4class{cm}
classes by calling \code{\link[=applyMagneticDeclination,adp-method]{applyMagneticDeclination,adp-method()}},
\code{\link[=applyMagneticDeclination,adv-method]{applyMagneticDeclination,adv-method()}}, or
\code{\link[=applyMagneticDeclination,cm-method]{applyMagneticDeclination,cm-method()}}, respectively.
}
\details{
The returned value is a copy of \code{object} that has been modified in 4 ways.
(1) the horizontal components of velocity are rotated clockwise by
\code{declination} degrees.  (2) If the object holds heading values, then
\code{declination} is added to them. (3) The \code{north} item in the \code{metadata} slot
is set to \code{"geographic"}, and a warning is issued if this was also the value
in \code{object}.  (4) The \code{declination} item in the \code{metadata} slot is set to
the value supplied to this function.
}
\seealso{
Use \code{\link[=magneticField]{magneticField()}} to determine the declination,
inclination and intensity at a given spot on the world, at a given time.

Other things related to magnetism: 
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{applyMagneticDeclination,adv-method}},
\code{\link{applyMagneticDeclination,cm-method}},
\code{\link{applyMagneticDeclination,oce-method}},
\code{\link{magneticField}()}
}
\author{
Dan Kelley, aided, for the \linkS4class{adp} and \linkS4class{adv} variants,
by Clark Richards and Jaimie Harbin.
}
\concept{things related to magnetism}
