% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.R
\name{metNames2oceNames}
\alias{metNames2oceNames}
\title{Convert met Data Name to Oce Name}
\usage{
metNames2oceNames(names, scheme)
}
\arguments{
\item{names}{a vector of character strings with original names}

\item{scheme}{an optional indication of the scheme that is employed. This may
be \code{"ODF"}, in which case \code{\link[=ODFNames2oceNames]{ODFNames2oceNames()}} is used,
or \code{"met"}, in which case some tentative code for met files is used.}
}
\value{
Vector of strings for the decoded names. If an unknown scheme is provided,
this will just be \code{names}.
}
\description{
Interoperability between oce functions requires that standardized data names
be used, e.g. \code{"temperature"} for in-situ temperature. Very few
data-file headers name the temperature column in exactly that way, however,
and this function is provided to try to guess the names. The task is complicated
by the fact that Environment Canada seems to change the names of the columns,
e.g. sometimes a symbol is used for the degree sign, other times not.
}
\details{
Several quantities in the returned object differ from their values in the source
file. For example, speed is converted from km/h to m/s, and angles are converted
from tens of degrees to degrees. Also, some items are created from scratch, e.g.
\code{u} and \code{v}, the eastward and northward velocity, are computed from speed
and direction. (Note that e.g. u is positive if the wind blows to the east; the
data are thus in the normal Physics convention.)
}
