% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{formatPosition}
\alias{formatPosition}
\title{Format Geographical Position in Degrees and Minutes}
\usage{
formatPosition(
  latlon,
  isLat = TRUE,
  type = c("list", "string", "expression"),
  showHemi = TRUE
)
}
\arguments{
\item{latlon}{a vector of latitudes or longitudes}

\item{isLat}{a boolean that indicates whether the quantity is latitude or
longitude}

\item{type}{a string indicating the type of return value (see below)}

\item{showHemi}{a boolean that indicates whether to indicate the hemisphere}
}
\value{
A list containing \code{degrees}, \code{minutes}, \code{seconds},
and \code{hemispheres}, or a vector of strings or (broken) a vector of
expressions.
}
\description{
Format geographical positions to degrees, minutes, and hemispheres
}
\examples{
library(oce)
formatPosition(10+1:10/60+2.8/3600)
formatPosition(10+1:10/60+2.8/3600, type="string")

}
\seealso{
Other functions related to maps: 
\code{\link{lonlat2map}()},
\code{\link{lonlat2utm}()},
\code{\link{map2lonlat}()},
\code{\link{mapArrows}()},
\code{\link{mapAxis}()},
\code{\link{mapContour}()},
\code{\link{mapCoordinateSystem}()},
\code{\link{mapDirectionField}()},
\code{\link{mapGrid}()},
\code{\link{mapImage}()},
\code{\link{mapLines}()},
\code{\link{mapLocator}()},
\code{\link{mapLongitudeLatitudeXY}()},
\code{\link{mapPlot}()},
\code{\link{mapPoints}()},
\code{\link{mapPolygon}()},
\code{\link{mapScalebar}()},
\code{\link{mapText}()},
\code{\link{mapTissot}()},
\code{\link{oceCRS}()},
\code{\link{shiftLongitude}()},
\code{\link{usrLonLat}()},
\code{\link{utm2lonlat}()}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
