% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{adpFlagPastBoundary}
\alias{adpFlagPastBoundary}
\title{Flag adp Data Past Water Column Boundary}
\usage{
adpFlagPastBoundary(
  x = NULL,
  fields = NULL,
  df = 20,
  trim = 0.15,
  good = 1,
  bad = 4,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{x}{an \linkS4class{adp} object containing bottom ranges.}

\item{fields}{a variable contained within \code{x} indicating which field to flag.}

\item{df}{the degrees of freedom to use during the smoothing spline operation.}

\item{trim}{a scale factor for boundary trimming (see \dQuote{Details}).}

\item{good}{number stored in flags to indicate good data.}

\item{bad}{number stored in flags to indicate bad data.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
\code{adpFlagPastBoundary} returns an \linkS4class{adp} object with flags
adjusted in the specified fields if data are beyond the water column boundary.
}
\description{
Flag variables with the same dimension of \code{v} in
an \linkS4class{adp} object that are beyond the water column boundary.
Currently, this operation can only be performed on \linkS4class{adp}
objects that contain bottom ranges. Commonly, \code{\link[=handleFlags]{handleFlags()}} would
then be used to remove such data.
}
\details{
This works by fitting a smoothing spline to a bottom range with a defined
number of degrees of freedom. For each time, it then searches to determine
which associated distances are greater than the predicted smooth spline
multiplied by \eqn{1-trim}.
}
\seealso{
Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp-class}},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adp_rdi.000}},
\code{\link{adp}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamToXyz}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOtherAdp}()},
\code{\link{enuToOther}()},
\code{\link{handleFlags,adp-method}},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{read.aquadopp}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnuAdp}()},
\code{\link{toEnu}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnuAdpAD2CP}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnu}()}
}
\author{
Jaimie Harbin, Clark Richards, and Dan Kelley
}
\concept{things related to adp data}
