% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{write.ctd}
\alias{write.ctd}
\title{Write a CTD Data Object as a CSV File}
\usage{
write.ctd(object, file, metadata = TRUE, flags = TRUE, format = "csv")
}
\arguments{
\item{object}{a \linkS4class{ctd} object.}

\item{file}{Either a character string (the file name) or a connection. If not
provided, \code{file} defaults to \code{\link[=stdout]{stdout()}}.}

\item{metadata}{a logical value indicating whether to put some selected
metadata elements at the start of the output file.}

\item{flags}{a logical value indicating whether to show data-quality flags
as well as data.}

\item{format}{string indicating the format to use. This may be \code{"csv"}
for a simple CSV format, or \code{"whp"} for the World Hydrographic
Program format, described in reference 1 and exemplified in reference 2.}
}
\description{
Writes a comma-separated file containing the data frame stored in
the \code{data} slot of the first argument.  The file is suitable
for reading with a spreadsheet, or
with \code{\link[=read.csv]{read.csv()}}.  This output file will contain
some of the metadata in \code{x}, if \code{metadata} is \code{TRUE}.
}
\examples{
\dontrun{
library(oce)
data(ctd)
write.ctd(ctd, "ctd.csv")
d <- read.csv("ctd.csv")
plot(as.ctd(d$salinity, d$temperature, d$pressure))
}

}
\references{
The following links used to work, but failed as of December 2020.
\enumerate{
\item \verb{https://www.nodc.noaa.gov/woce/woce_v3/wocedata_1/whp/exchange/exchange_format_desc.htm}
\item \verb{https://www.nodc.noaa.gov/woce/woce_v3/wocedata_1/whp/exchange/example_ct1.csv}
}
}
\seealso{
The documentation for \linkS4class{ctd} explains the structure
of CTD objects.

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{[[<-,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()}
}
\author{
Dan Kelley
}
\concept{things related to ctd data}
