% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobo.R
\docType{class}
\name{lobo-class}
\alias{lobo-class}
\title{Class to Store LOBO Data}
\description{
This class stores LOBO data.
}
\details{
A \code{lobo} object may be read with \code{\link{read.lobo}} or
constructed with \code{\link{as.lobo}}.  Plots can be made with
\code{\link{plot,lobo-method}}, while \code{\link{summary,lobo-method}} produces
statistical summaries. Data within a \code{lobo} object may be retrieved with
\code{\link{[[,lobo-method}} and altered with \code{\link{[[,lobo-method}}.
}
\section{Slots}{

\describe{
\item{\code{data}}{As with all \code{oce} objects, the \code{data} slot
for \code{lobo} objects is a
\code{\link{list}} containing the main data for the object.
{}}

\item{\code{metadata}}{As with all \code{oce} objects, the \code{metadata} slot
for \code{lobo} objects is a \code{\link{list}} containing
information about the \code{data} or about the object itself.
{}}

\item{\code{processingLog}}{As with all \code{oce} objects, the \code{processingLog} slot
for \code{lobo} objects is a
\code{\link{list}} with entries describing the creation and evolution
of the object. The contents are updated by various \code{oce} functions to
keep a record of processing steps.  Object summaries and
\code{\link{processingLogShow}} both display the log.}
}}

\section{Modifying slot contents}{


Although the \code{[[<-} operator may permit modification of the contents
of \code{lobo} objects (see \code{\link{[[<-,lobo-method}}),
it is better to use \code{\link{oceSetData}}
and \code{\link{oceSetMetadata}}, because that will save an entry
in the \code{processingLog} to describe the change.
}

\section{Retrieving slot contents}{


The full contents of the \code{data} and \code{metadata} slots of a \code{lobo}
object named \code{lobo} may be retrieved in the standard R way. For example,
\code{slot(lobo, "data")} and \code{slot(lobo, "metadata")} return
the \code{data} and \code{metadata} slots, respectively. The
\code{\link{[[,lobo-method}} operator can also be used to access slots,
with \code{lobo[["data"]]} and \code{lobo[["metadata"]]}, respectively.
Furthermore, \code{\link{[[,lobo-method}} can be used to retrieve
named items (and potentially some derived items) within the
\code{metadata} and \code{data} slots, the former taking precedence
over the latter in the lookup. It is also possible
to find items more directly, using \code{\link{oceGetData}} and
\code{\link{oceGetMetadata}}, but this cannot retrieve derived items.
}

\seealso{
Other classes provided by oce: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{lisst-class}}, \code{\link{met-class}},
  \code{\link{oce-class}}, \code{\link{odf-class}},
  \code{\link{rsk-class}}, \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to lobo data: \code{\link{[[,lobo-method}},
  \code{\link{[[<-,lobo-method}}, \code{\link{as.lobo}},
  \code{\link{lobo}}, \code{\link{plot,lobo-method}},
  \code{\link{read.lobo}},
  \code{\link{subset,lobo-method}},
  \code{\link{summary,lobo-method}}
}
\author{
Dan Kelley
}
\concept{classes provided by oce}
\concept{things related to lobo data}
