% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{tidemAstron}
\alias{tidemAstron}
\title{Astronomical Calculations for Tidem}
\usage{
tidemAstron(t)
}
\arguments{
\item{t}{Either a time in \code{POSIXct} format (with \code{"UTC"} timezone),
or an integer. In the second case, it is converted to a time with
\code{\link{numberAsPOSIXct}(t,tz="UTC")}.
If \code{t} (It is \strong{very} important to use \code{tz="GMT"} in constructing \code{t}.)}
}
\value{
A \code{\link[base]{list}} containing items named
\code{astro} and \code{ader} (see \code{T_TIDE} documentation).
}
\description{
Do some astronomical calculations for \code{\link{tidem}}.  This function is based directly
on \code{t_astron} in the \code{T_TIDE} Matlab package [1].
}
\examples{
tidemAstron(as.POSIXct("2008-01-22 18:50:24"))
}
\references{
1. Pawlowicz, Rich, Bob Beardsley, and Steve Lentz, 2002. Classical tidal
harmonic analysis including error estimates in MATLAB using \code{T_TIDE}.
Computers and Geosciences, 28, 929-937.
}
\seealso{
Other things related to \code{tidem} data: \code{\link{[[,tidem-method}},
  \code{\link{[[<-,tidem-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{predict.tidem}},
  \code{\link{summary,tidem-method}},
  \code{\link{tidedata}}, \code{\link{tidem-class}},
  \code{\link{tidemVuf}}, \code{\link{tidem}}
}
\author{
Dan Kelley translated this from \code{t_astron} in the \code{T_TIDE}
package.
}
