% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observatory.R
\name{read.observatory}
\alias{read.observatory}
\title{Read observatory data file}
\usage{
read.observatory(file, type = c("ctd"), debug = getOption("oceDebug"),
  processingLog, ...)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.}

\item{type}{type of data; must be \code{"ctd"}, the only type handled at
present.}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}

\item{\dots}{additional arguments, passed to called routines.}
}
\value{
An object of \code{\link[base]{class}} \code{"ctd"}.
}
\description{
This is a preliminary version of a function that may be extended or
deleted in a future version of Oce.  Part of the uncertainty is that the
format was inferred from inspection of files, and this is a dangerous
procedure, path because the data archiver might alter formats in future.
}
\author{
Dan Kelley
}
\references{
\url{http://venus.uvic.ca/data/data-archive/}
}
\seealso{
The documentation for \code{\link{ctd-class}} explains the
structure of \code{ctd} objects, and also outlines the other functions
dealing with them.
}

