% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echosounder.R
\docType{methods}
\name{plot,echosounder-method}
\alias{plot,echosounder-method}
\title{Plot Echosounder Data}
\usage{
\S4method{plot}{echosounder}(x, which = 1, beam = "a", newx, xlab, ylab,
  xlim, ylim, zlim, type = "l", col = oce.colorsJet, lwd = 2,
  despike = FALSE, drawBottom, ignore = 5, drawTimeRange = FALSE,
  drawPalette = TRUE, radius, coastline, adorn = NULL,
  mgp = getOption("oceMgp"), mar = c(mgp[1] + 1, mgp[1] + 1, mgp[1] + 1,
  mgp[1] + 1), atTop, labelsTop, tformat, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{An \code{echosounder} object, e.g. as read by
\code{\link{read.echosounder}}, or created by \code{\link{as.echosounder}}.}

\item{which}{list of desired plot types: \code{which=1} or \code{which="zt
image"} gives a z-time image, \code{which=2} or \code{which="zx image"}
gives a z-distance image, and \code{which=3} or \code{which="map"} gives a
map showing the cruise track.  In the image plots, the display is of
\code{\link{log10}} of amplitude, trimmed to zero for any amplitude values
less than 1 (including missing values, which equal 0).  Add 10 to the
numeric codes to get the secondary data (non-existent for single-beam files,}

\item{beam}{a more detailed specification of the data to be plotted.  For
single-beam data, this may only be \code{"a"}.  For dual-beam data, this may
be \code{"a"} for the narrow-beam signal, or \code{"b"} for the wide-beam
signal.  For split-beam data, this may be \code{"a"} for amplitude,
\code{"b"} for x-angle data, or \code{"c"} for y-angle data.}

\item{newx}{optional vector of values to appear on the horizontal axis if
\code{which=1}, instead of time.  This must be of the same length as the
time vector, because the image is remapped from time to \code{newx} using
\code{\link{approx}}.}

\item{xlab, ylab}{optional labels for the horizontal and vertical axes; if
not provided, the labels depend on the value of \code{which}.}

\item{xlim}{optional range for x axis.}

\item{ylim}{optional range for y axis.}

\item{zlim}{optional range for colour scale.}

\item{type}{type of graph, \code{"l"} for line, \code{"p"} for points, or
\code{"b"} for both.}

\item{col}{colour scale for image, a function}

\item{lwd}{line width (ignored if \code{type="p"})}

\item{despike}{remove vertical banding by using \code{\link{smooth}} to
smooth across image columns, row by row.}

\item{drawBottom}{optional flag used for section images.  If \code{TRUE},
then the bottom is inferred as a smoothed version of the ridge of highest
image value, and data below that are grayed out after the image is drawn.
If \code{drawBottom} is a colour, then that colour is used, instead of
white.  The bottom is detected with \code{\link{findBottom}}, using the
\code{ignore} value described next.}

\item{ignore}{optional flag specifying the thickness in metres of a surface
region to be ignored during the bottom-detection process.  This is ignored
unless \code{drawBottom=TRUE}.}

\item{drawTimeRange}{if \code{TRUE}, the time range will be drawn at the
top.  Ignored except for \code{which=2}, i.e. distance-depth plots.}

\item{drawPalette}{if \code{TRUE}, the palette will be drawn.}

\item{radius}{radius to use for maps; ignored unless \code{which=3} or
\code{which="map"}.}

\item{coastline}{coastline to use for maps; ignored unless \code{which=3} or
\code{which="map"}.}

\item{adorn}{(\strong{Defunct})
An \code{\link{expression}} or vector of expressions that contain
R code that is to be executed immediately after each panel of the plot.
If the number of expressions matches the number of panels, then the 
expressions are used for the corresponding panels; otherwise, the
expression list is extended to match the number of panels (i.e.
to obtain \code{length(which)} elements). Note that \code{adorn}
is a dangerous argument, because if the expressions contained
therein set up local storage, there is a chance of entirely
disrupting the plotting. \strong{For this reason, \code{adorn} was
marked as defunct in June 2016, and will be removed entirely 
after the July CRAN release.} Users with existing code that uses
\code{adorn} should simply plot the panels individually, and
use conventional R functions, e.g. \code{\link{lines}} etc.,
after each panel, to achieve the desired effect.  (See
\code{\link{oce-defunct}} for notes on other deprecated or
defunct \code{oce} features.)}

\item{mgp}{3-element numerical vector to use for \code{par(mgp)}, and also
for \code{par(mar)}, computed from this.  The default is tighter than the R
default, in order to use more space for the data and less for the axes.}

\item{mar}{value to be used with \code{\link{par}("mar")}.}

\item{atTop}{optional vector of time values, for labels at the top of the
plot produced with \code{which=2}.  If \code{labelsTop} is provided, then it
will hold the labels.  If \code{labelsTop} is not provided, the labels will
be constructed with the \code{\link{format}} function, and these may be
customized by supplying a \code{format} in the \dots{} arguments.}

\item{labelsTop}{optional vector of character strings to be plotted above
the \code{atTop} times.  Ignored unless \code{atTop} was provided.}

\item{tformat}{optional argument passed to \code{\link{imagep}}, for plot
types that call that function.  (See \code{\link{strptime}} for the format
used.)}

\item{debug}{set to an integer exceeding zero, to get debugging information
during processing.}

\item{\dots}{optional arguments passed to plotting functions.  For example,
for maps, it is possible to specify the radius of the view in kilometres,
with \code{radius}.}
}
\value{
A list is silently returned, containing \code{xat} and \code{yat},
values that can be used by \code{\link{oce.grid}} to add a grid to the plot.
}
\description{
Plot echosounder data.
Simple linear approximation is used when a \code{newx} value is specifie
with the \code{which=2} method, but arguably a gridding method should be
used, and this may be added in the future.
}
\examples{

\dontrun{
library(oce)
data(echosounder)
plot(echosounder, which=c(1,2), drawBottom=TRUE)
}
}
\author{
Dan Kelley, with extensive help from Clark Richards
}
\seealso{
Other things related to \code{echosounder} data: \code{\link{[[,echosounder-method}},
  \code{\link{[[<-,echosounder-method}},
  \code{\link{as.echosounder}},
  \code{\link{echosounder-class}},
  \code{\link{echosounder}}, \code{\link{findBottom}},
  \code{\link{read.echosounder}},
  \code{\link{subset,echosounder-method}},
  \code{\link{summary,echosounder-method}}
}

