% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_training.R
\name{train_similarity_based_reasoning}
\alias{train_similarity_based_reasoning}
\title{Train Similarity Based Probability Model with anonymized training data}
\usage{
train_similarity_based_reasoning(
  anonymized_data,
  num_allowed_codes = 1291,
  coding_index_w_codes,
  coding_index_without_codes = NULL,
  preprocessing = list(stopwords = NULL, stemming = NULL, strPreprocessing = TRUE,
    removePunct = FALSE),
  dist_type = c("wordwise", "substring", "fulltext"),
  dist_control = list(method = "osa", weight = c(d = 1, i = 1, s = 1, t = 1)),
  threshold = c(max = 3, use = 1),
  simulation_control = list(n.draws = 250, check_normality = FALSE)
)
}
\arguments{
\item{anonymized_data}{\code{surveyCountsSubstringSimilarity} or \code{surveyCountsWordwiseSimilarity}}

\item{num_allowed_codes}{the number of allowed codes in the target classification. There are 1286 categories in the KldB 2010 plus 5 special codes in both anonymized training data sets, so the default value is 1291.}

\item{coding_index_w_codes}{a data.table with columns
\describe{
\item{bezMale}{a character vector, contains masculine job titles from the coding index.}
\item{bezFemale}{a character vector, contains feminine job titles from the coding index.}
\item{Code}{a character vector with associated classification codes.}
}}

\item{coding_index_without_codes}{(not used, but automatically determined) Any words from \code{anonymized_data$dictString} that are not found within \code{coding_index_w_codes} belong into this character vector.}

\item{preprocessing}{a list with elements
\describe{
\item{stopwords}{a character vector, use \code{tm::stopwords("de")} for German stopwords. Only used if \code{dist_type = "wordwise"}.}
\item{stemming}{\code{NULL} for no stemming and \code{"de"} for stemming using the German porter stemmer. Do not use unless the job titles in \code{coding_index_w_codes} were stemmed.}
\item{strPreprocessing}{\code{TRUE} if \code{\link{preprocess_string}} shall be used.}
\item{removePunct}{\code{TRUE} if \code{\link[tm]{removePunctuation}} shall be used.}
}}

\item{dist_type}{How to calculate similarity between entries from both coding_indices and verbal answers from the survey? Three options are currently supported.  Since we use the \code{\link[stringdist]{stringdist}}-function excessively, one could easily extend the functionality of this procedure to other distance metrics.
\describe{
\item{dist_type = "fulltext"}{Uses the \code{\link[stringdist]{stringdist}}-function directly after preprocessing to calculate distances. (the simplest approach but least useful.)}
\item{dist_type = "substring"}{An entry from the coding index and a verbal answer are similar if the entry from the coding index is a substring of the verbal answer.}
\item{dist_type = "wordwise"}{After preprocessing, split the verbal answer into words. Then calculate for each word separately the the similarity with entries from the coding index, using \code{\link[stringdist]{stringdist}}. Not the complete verbal answer but only the words (0 or more) that have highest similarity are then used to determine similarity with entries from the coding index.}
}}

\item{dist_control}{If \code{dist_type = "fulltext"} or \code{dist_type = "wordwise"} the entries from this list will be passed to \code{\link[stringdist]{stringdist}}. Currently only two possible entries are supported (method = "osa", weight = c(d = 1, i = 1, s = 1, t = 1) is recommended), but one could easily extend the functionality.}

\item{threshold}{A numeric vector with two elements. If \code{dist_type = "fulltext"} or \code{dist_type = "wordwise"}, the threshold determines up to which distance a verbal answer and an entry from the coding index are similar. The second number actually gets used. The first number is only used to speed up similarity calculations. It should be identical or larger than the second number.}

\item{simulation_control}{a list with two components,
\describe{
\item{n.draws}{Number of draws from the posterior distribution to determine posterior predictive probabilities. The larger, the more precise the results will be.}
\item{check_normality}{We would like that the hyperprior distribution is normal. Set check_normality to TRUE to do some diagnostics about this.}
}}
}
\value{
a list with components
\describe{
\item{prediction.datasets$modelProb}{Contains all entries from the coding index. dist = "official" if the entry stems from coding_index_w_codes and dist = selfcreated if the entry stems from coding_index_without_codes. \code{string.prob} is used for weighting purposes (model averaging) if a new verbal answer is similar to multiple strings. \code{unobserved.mean.theta} gives a probability (usually very low) for any category that was not observed in the training data together with this string.}
\item{prediction.datasets$categoryProb}{\code{mean.theta} is the probability for \code{code} given that an incoming verbal answer is similar to \code{string}. Only available if this code was at least a single time observed with this string (Use \code{unobserved.mean.theta} otherwise).}
\item{num_allowed_codes}{Number of categories in the classification.}
\item{preprocessing}{The input parameter stored to replicate preprocessing with incoming data.}
\item{dist_type}{The input parameter stored to replicate distance calculations with incoming data.}
\item{dist_control}{The input parameter stored to replicate distance calculations with incoming data.}
\item{threshold}{The input parameter stored to replicate distance calculations with incoming data.}
\item{simulation_control}{The input parameters controlling the Monte Carlo simulation.}
}
}
\description{
This function requires the mvtnorm package.
}
\references{
Schierholz, Malte (2019): New methods for job and occupation classification. Dissertation, Mannheim. \url{https://madoc.bib.uni-mannheim.de/50617/}, pp. 206-208 and p. 268, pp. 308-320

\url{https://github.com/malsch/occupationCoding} (function trainSimilarityBasedReasoning2 is implemented here)
}
\seealso{
\link{pretrained_models}, which were created using this function.
}
