% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{load_auxco}
\alias{load_auxco}
\title{Load AuxCO from a directory of CSV files}
\usage{
load_auxco(dir, add_explanations = TRUE)
}
\arguments{
\item{dir}{The path to the directory which holds the CSVs.}

\item{add_explanations}{Whether explanations should be added to some of the
harder to understand task descriptions. Defaults to TRUE.}
}
\value{
A list with multiple data.tables.
}
\description{
This function loads the Auxiliary Classification of Occupations (AuxCO) by
reading CSVs from the specified directory, while loading e.g. ids in the
correct format. Data is loaded into a named list matching the format
expected by other functions in this package.
}
\details{
This package also includes an already loaded version of the \link{auxco}, which
can be used straight away \emph{without} calling this function.
}
\examples{
# This function expects the CSV files from
# https://github.com/occupationMeasurement/auxiliary-classification/releases/
# to be there.
path_to_auxco <- "auxco"
if (dir.exists(path_to_auxco)) {
  load_auxco(path_to_auxco)
}
}
\seealso{
https://github.com/occupationMeasurement/auxiliary-classification, \link{auxco}
}
