% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggestions.R
\name{get_final_codes}
\alias{get_final_codes}
\title{Get the final occupation codes}
\usage{
get_final_codes(
  suggestion_id,
  followup_answers = list(),
  standardized_answer_levels = NULL,
  approximate_standardized_answer_levels = TRUE,
  code_type = c("isco_08", "kldb_10"),
  verbose = TRUE,
  suggestion_type = "auxco-1.2.x",
  suggestion_type_options = list()
)
}
\arguments{
\item{suggestion_id}{Id of the suggestion}

\item{followup_answers}{A named list of the question_ids with their
respective answers to the followup_questions.
Question ids correspond to list names, answers correspond to list values.}

\item{standardized_answer_levels}{A named list of standardized isco
answer levels. Names in the list correspond to the type of isco standard,
values correspond to the level itself.
Possible standardized answer types are: "isco_skill_level" and
"isco_supervisor_manager".
These can be used instead of some followup questions if
the information is available already from a different source.
Please note that standardized answer levels are \emph{not} available for all
question types. For a list of options please take a look at the
followup questions included in the auxco for example via
\code{occupationMeasurement::auxco$followup_questions}.}

\item{approximate_standardized_answer_levels}{(default TRUE) Follow up
questions were designed to provide answer options that are not in conflict with suggestion_id.
standardized_answer_levels can be in conflict with suggestion_id, and then no exact matches
exist. With approximation, the answer option that is closest to the
standardized_answer_levels provided, will be used.}

\item{code_type}{Which type of codes should be returned.
Multiple codes can be returned at the same time.
Supported types of codes are "isco_08" and "kldb_10".
Defaults to "isco_08" and "kldb_10".}

\item{verbose}{(default TRUE) whether to return a \code{message} or not, detailing potential issues with the input provided.}

\item{suggestion_type}{Which suggestion type is being used.
Only auxco-based suggestion_types are supported.}

\item{suggestion_type_options}{A list with options for generating
suggestions. Supported options:
- \code{datasets}: Pass specific datasets to be used whenn adding information
to predictions e.g. use a specific version of the kldb or auxco.
Supported datasets are: "auxco-1.2.x", "kldb-2010". By default the datasets
bundled with this package are used.}
}
\value{
A named list corresponding to the code_type(s) specified. Includes a \code{message} if \code{verbose = TRUE}
}
\description{
The final occupation code will depend on the \code{suggestion_id} and,
possibly, on \code{followup_answers}, depending on the \code{suggestion_id} provided. See
\code{occupationMeasurement::auxco$followup_questions} for a list of suggestion_ids (=auxco_id)
and their respective recommended follow-up questions.
}
\details{
The interview situation may not allow to ask these follow-up questions. Some default, but
suboptimal occupation code is returned if \code{followup_answers} is missing.

If \code{followup_answers} is missing or incomplete, one may wish to insert/infer the missing information
by using \code{standardized_answer_levels}.
}
\examples{
get_final_codes(
  # Führungsaufgaben mit Personalverantwortung  bei der Lebensmittelherstellung
  "9076",
  followup_answers = list(
    # The first answer option in the first followup question
    "Q9076_1" = 2
  )
)

# The same, but using standardized answer levels
get_final_codes(
  # Führungsaufgaben mit Personalverantwortung  bei der Lebensmittelherstellung
  "9076",
  standardized_answer_levels = list(
    # A response corresponding to the standard ISCO Level "supervisor"
    "isco_supervisor_manager" = "isco_supervisor"
  )
)

# Same example with approximate matching, due to conflicting information:
# External data suggest the person is not a supervisor, but the person still
# says she does supervisory tasks (Führungsaufgaben, as encoded in "9076").
# If approximate_standardized_answer_levels = TRUE (the default), the
# selected answer "9076" trumps the external data and we will code this
# person as a supervisor.
get_final_codes(
  # Führungsaufgaben mit Personalverantwortung  bei der Lebensmittelherstellung
  "9076",
  standardized_answer_levels = list(
    # A response corresponding to the standard ISCO Level "not manager nor supervisor"
    "isco_supervisor_manager" = "isco_not_supervising"
  )
)
}
