% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landFilter.R.R
\name{landSeaFilter}
\alias{landSeaFilter}
\title{Filter occurrence by habitat (terrestrial/non-Terrestrial)}
\usage{
landSeaFilter(df, xf, yf, habType = NULL, verbose = TRUE, habPol = NULL)
}
\arguments{
\item{df}{Data.frame of species occurrences}

\item{xf}{the field in the dataframe containing the x cordinates}

\item{yf}{the field in the dataframe containing the y cordinates}

\item{habType}{character. Define the species habitat. Only "terrestrial" and "sea" implemented.}

\item{verbose}{logical. Print messages? Default TRUE}

\item{habPol}{sf polygon boject. Shows land masses}
}
\value{
list
}
\description{
Filter the occurrence recoreds  according to whether they should be in land masses or not
}
\examples{
\donttest{
xyDF <- data.frame (x=c(0,42),y=c(0,1),Reason=NA)
landSeaFilter(xyDF,xf='x',yf='y')
}
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr)
}
\keyword{filter}
