% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_longterm_and_macro_data}
\alias{example_longterm_and_macro_data}
\title{Example Longterm and Macro Data}
\format{
A data frame with 16 rows and 14 columns:
\describe{
\item{\code{country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{year}}{The year of the observation.}
\item{\code{avg_hourly_demand}}{The average hourly electricity demand (in megawatts) for the respective year.}
\item{\code{population}}{The total population in the respective year.}
\item{\code{GDP}}{Gross Domestic Product (in constant 2015 USD) in the respective year.}
\item{\code{industrial_value_added}}{The percentage of GDP attributed to industrial value-added activities.}
\item{\code{manufacturing_value_added}}{The percentage of GDP attributed to manufacturing value-added activities.}
\item{\code{GDP_growth}}{The GDP growth rate (in percentage) for the respective year.}
\item{\code{GDP_deflator}}{The GDP deflator (in percentage), which measures price inflation or deflation.}
\item{\code{service_value_added}}{The percentage of GDP attributed to service sector value-added activities.}
\item{\code{GNI}}{Gross National Income (in constant 2015 USD) in the respective year.}
\item{\code{household_consumption_expenditure}}{The percentage of GDP attributed to household consumption expenditure.}
\item{\code{rural_population}}{The rural population in the respective year.}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
}
\source{
World Development Indicators (WDI) of the World Bank (https://databank.worldbank.org/source/world-development-indicators); Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/); ENTSO-E Power Stats Archive (https://www.entsoe.eu/data/power-stats/)
}
\usage{
example_longterm_and_macro_data
}
\description{
This dataset extends the long-term average hourly electricity demand data from \code{\link{example_longterm_data}} with ten macro-economic indicators. The macro-economic data is taken from the World Development Indicators (WDI) of the World Bank (https://databank.worldbank.org/source/world-development-indicators).
}
\keyword{dataset}
\keyword{longterm}
\keyword{macro-economic}
