% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateFragment.R
\name{updateFragment}
\alias{updateFragment}
\title{Update a transcript fragment}
\usage{
updateFragment(labbcat.url, fragment.path)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{fragment.path}{The path to the fragment to upload.}
}
\value{
A named list with information about the fragment that was updated.
}
\description{
This function uploads a file (e.g. Praat TextGrid) representing a fragment of a
transcript, with annotations or alignments to update in LaBB-CAT's version of the
transcript.
}
\details{
For this function to work, the credentials used to connect to the server must have at
least 'edit' access.
}
\examples{
\dontrun{
## upload new verison of transcript transcript
updateFragment(labbcat.url, "my-transcript__1.234-5.678.TextGrid")
}
}
\keyword{management}
\keyword{transcript}
