% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_open_parking_camera_violations.R
\name{nyc_open_parking_camera_violations}
\alias{nyc_open_parking_camera_violations}
\title{Open Parking and Camera Violations}
\source{
NYC Open Data: <https://data.cityofnewyork.us/City-Government/Open-Parking-and-Camera-Violations/nc67-uf89/about_data>
}
\usage{
nyc_open_parking_camera_violations(
  limit = 10000,
  filters = list(),
  timeout_sec = 30
)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Open Parking and Camera Violations data.
}
\description{
Downloads Open Parking and Camera Violations data from NYC Open Data.
}
\details{
The Open Parking and Camera Violations dataset was initially loaded with all violations contained in the mainframe database as of May 2016.
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_open_parking_camera_violations(limit = 2)
  small_sample

  nyc_open_parking_camera_violations(filters = list(state = "NJ"))
}
}
}
