% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_violent_disruptive_school_incidents.R
\name{nyc_violent_disruptive_school_incidents}
\alias{nyc_violent_disruptive_school_incidents}
\title{NYC Violent and Disruptive Incidents}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/fpci-ws56>
}
\usage{
nyc_violent_disruptive_school_incidents(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Violent and Disruptive Incidents data.
}
\description{
Downloads Violent and Disruptive Incidents data from NYC Open Data.
}
\details{
Incident counts and rates reported by NYC schools, broken out by incident
category, school, and school year. Useful for safety trend analyses and
comparisons across school types.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_violent_disruptive_school_incidents(limit = 10)
head(small_sample)

\donttest{
nyc_violent_disruptive_school_incidents(limit = 5000)
nyc_violent_disruptive_school_incidents(filters = list(school_type = "Public"))
}
}
