% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuts_convert_version.R
\name{nuts_convert_version}
\alias{nuts_convert_version}
\title{Convert between NUTS versions}
\usage{
nuts_convert_version(
  data,
  to_version,
  variables,
  weight = NULL,
  missing_rm = FALSE,
  missing_weights_pct = FALSE,
  multiple_versions = c("error", "most_frequent")
)
}
\arguments{
\item{data}{A nuts.classified object returned by \code{\link[=nuts_classify]{nuts_classify()}}.}

\item{to_version}{String with desired NUTS version the function should convert to. Possible versions: \code{'2006'}, \code{'2010'}, \code{'2013'}, \code{'2016'} or \code{'2021'}}

\item{variables}{Named character specifying variable names and variable type (\code{'absolute'} or \code{'relative'}) e.g. \code{c('var_name' = 'absolute')}}

\item{weight}{String with name of the weight used for conversion. Can be area size \code{'areaKm'} (default),
population in 2011 \code{'pop11'} or 2018 \code{'pop18'}, or artificial surfaces in 2012 \code{'artif_surf12'} and 2018 \code{'artif_surf18'}.}

\item{missing_rm}{Boolean that is FALSE by default. TRUE removes regional flows that depart from missing NUTS codes.}

\item{missing_weights_pct}{Boolean that is FALSE by default. TRUE computes the percentage of missing weights due to missing departing NUTS regions for each variable.}

\item{multiple_versions}{By default equal to \code{'error'}, when providing multiple NUTS versions within groups.
If set to \code{'most_frequent'} data is converted using the best-matching NUTS version.}
}
\value{
A tibble containing NUTS codes, converted variable values, and possibly grouping variables.
}
\description{
\code{nuts_convert_version()} transforms regional NUTS data between NUTS versions.
}
\details{
Console messages can be controlled with \code{rlang::local_options(nuts.verbose = "quiet")} to silence messages and
\code{nuts.verbose = "verbose"} to switch messages back on.
}
\examples{
library(dplyr)

# Load EUROSTAT data of manure storage deposits
data(manure)

# Data varies at the NUTS level x indicator x year x country x NUTS code level
head(manure)

# Convert NUTS 2 codes in Germany from 2006 to 2021 version
manure \%>\%
  filter(nchar(geo) == 4) \%>\%
  filter(indic_ag == 'I07A_EQ_Y') \%>\%
  filter(grepl('^DE', geo)) \%>\%
  filter(time == 2003) \%>\%
  select(-indic_ag, -time) \%>\%
  # Data now only varies at the NUTS code level
  nuts_classify(nuts_code = "geo") \%>\%
  nuts_convert_version(to_version = '2021',
                       weight = 'pop18',
                       variables = c('values' = 'absolute'))


# Convert NUTS 3 codes by country x year, classifying version first
manure \%>\%
  filter(nchar(geo) == 5) \%>\%
  filter(indic_ag == 'I07A_EQ_Y') \%>\%
  select(-indic_ag) \%>\%
  # Data now varies at the year x NUTS code level
  nuts_classify(nuts_code = 'geo', group_vars = c('time')) \%>\%
  nuts_convert_version(to_version = '2021',
                       weight = 'pop18',
                       variables = c('values' = 'absolute'))


}
