% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_parenthesis.R
\name{f_parenthesis}
\alias{f_parenthesis}
\alias{ff_parenthesis}
\alias{f_mean_sd}
\alias{ff_mean_sd}
\alias{f_num_percent}
\alias{ff_num_percent}
\title{Parenthesis Formatting of Two Vectors}
\usage{
f_parenthesis(x, y, sep = "", x_prefix = "", y_prefix = "", ...)

ff_parenthesis(...)

f_mean_sd(x, y, x_digits = 1, y_digits = x_digits, sep = "", ...)

ff_mean_sd(...)

f_num_percent(
  x,
  y,
  x_digits = 1,
  y_digits = x_digits,
  sep = "",
  prop_fun = numform::f_prop2percent,
  ...
)

ff_num_percent(...)
}
\arguments{
\item{x}{Vector 1 (in \code{f_mean_sd} the mean values and in
\code{f_num_percent} the leading number vector).}

\item{y}{Vector 2 (in \code{f_mean_sd} the standard deviation values and in
\code{f_num_percent} the percent/proportion vector).}

\item{sep}{The separator between the first number and the leading parenthesis.}

\item{x_prefix}{A constant to place before each value in the x vector.}

\item{y_prefix}{A constant to place before each value in the y
vector inside of the parenthesis.}

\item{x_digits}{The number of digits to round the x vector.}

\item{y_digits}{The number of digits to round the y vector.}

\item{prop_fun}{The proportion function to convert the y y vector in
\code{f_num_percent}.  Default is \code{f_prop2percent}.  \code{f_percent} is
used for when the values are already percentages.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of parenthesis combined strings using vector x and y.
}
\description{
\code{f_parenthesis} - Form two vectors of numbers as a leading number
followed by a second number in parenthesis.

\code{f_mean_sd} - Wrapper for \code{f_parenthesis} optimized for formatting
vectors of means and standard deviations.

\code{f_num_percent}  - Wrapper for \code{f_parenthesis} optimized for formatting
vectors of numbers and percentages deviations.
}
\examples{
f_parenthesis(
    f_num(sample(50:100, 5), 1),
    f_num(rnorm(5, 5:15, 5), 1),
    prefix = 'mean = ',
    parenthesis_prefix = 'sd = ',
    sep = " "
)

f_mean_sd(rnorm(5, 100, 20), rnorm(5, 20, 5))

f_num_percent(rnorm(5, 100, 20), rnorm(5, .5, .1))

f_parenthesis(
    sample(50:100, 5),
    f_prop2percent(rnorm(5, .5, .1), 0)
)

 \dontrun{
library(tidyverse)
mtcars \%>\%
    group_by(cyl) \%>\%
    summarize(
        mean = mean(hp),
        sd = sd(hp),
        n = n()
    ) \%>\%
    mutate(
        prop = n /sum(n),
        mean_sd = f_mean_sd(mean, sd),
        n_perc = f_num_percent(n, prop, 0)
    )
}
}
