% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_grid.R
\name{var_grid}
\alias{var_grid}
\title{Create a tibble of combinations of xvar/yvar variable pairs.}
\usage{
var_grid(x, xvars = everything(), yvars = everything())
}
\arguments{
\item{x}{either a data frame or a matrix}

\item{xvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns of \code{x}, whose names will be used as a domain for
combinations use at the first place (xvar)}

\item{yvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns of \code{x}, whose names will be used as a domain for
combinations use at the second place (yvar)}
}
\value{
a tibble with two columns (\code{xvar} and \code{yvar}) with rows enumerating
all combinations of column names specified by tidyselect expressions
in \code{xvars} and \code{yvars} arguments.
}
\description{
The function creates a tibble with two columns, \code{xvar} and \code{yvar}, whose
rows enumerate all combinations of column names specified in the \code{xvars}
and \code{yvars} argument. The column names to create the combinations from are
specified using a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax}).
}
\examples{
var_grid(CO2)
var_grid(CO2, xvars = Plant:Treatment, yvars = conc:uptake)

}
\author{
Michal Burda
}
