% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorsinclasses.R
\name{colors.in.classes}
\alias{colors.in.classes}
\title{Compute colors in classes distribution}
\usage{
colors.in.classes(classes, color1, color2 = NULL, mask = array(TRUE,
  dim(classes)), N = max(classes, na.rm = TRUE), type = "tresh",
  thresh1 = NULL, thresh2 = NULL, sd1 = 2, sd2 = 2,
  col1 = "green", col2 = "red", test = FALSE, plot = TRUE,
  beside = TRUE, ylim = NULL, ...)
}
\arguments{
\item{classes}{Image of classes}

\item{color1}{Image of first color}

\item{color2}{Image of second color}

\item{mask}{Image mask}

\item{N}{Maximum number of classes}

\item{type}{Type of spot definition, see details}

\item{thresh1}{Threshold for first color image}

\item{thresh2}{Threshold for second color image}

\item{sd1}{For automatic threshold, that is: mean(color1)+sd1*sd(color1)}

\item{sd2}{For automatic threshold of color2}

\item{col1}{Name of color 1}

\item{col2}{Name of color 2}

\item{test}{Compute tests: "Wilcoxon" for Wilcoxon rank-sum (Mann-Whitney U), chisq for Chi-squared test}

\item{plot}{Plot barplots}

\item{beside}{a logical value. If FALSE, the columns of height are portrayed as stacked bars, and if TRUE the columns are portrayed as juxtaposed bars.}

\item{ylim}{limits for the y axis (plot)}

\item{...}{additional plotting parameters}
}
\value{
Table of classes with color 1 (and 2)
}
\description{
Compute colors in classes distribution
}
\details{
Type of spot definitions:
"thresh" or "t": Threshold based (threshold can be given by thresh1/2 or automatically derived)
"voxel" or "v": Spots are given as binary voxel mask
"intensity" or "i": Voxels are weighted with voxel intensity
}
