% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpu.time.R, R/h.cv.R, R/interp.R, R/npsp-internals.R, R/splot.R
\name{.cpu.time.ini}
\alias{.compute.masked}
\alias{.cpu.time.ini}
\alias{.rev.colorRampPalette}
\alias{.wloss}
\alias{as.data.frame.grid.par}
\alias{dim.data.grid}
\alias{dim.grid.par}
\alias{dimnames.data.grid}
\alias{dimnames.grid.par}
\alias{is.data.grid}
\alias{npsp-internals}
\alias{print.grid.par}
\alias{residuals.locpol.bin}
\alias{splot.plt}
\title{npsp internal and secondary functions}
\usage{
.cpu.time.ini()

.compute.masked(bin, cov.bin = NULL, tol.mask = npsp.tolerance(2))

.wloss(est, teor, w, loss = c("ASE", "ARSE", "AAE", "ARAE"))

\method{residuals}{locpol.bin}(object, ...)

\method{print}{grid.par}(x, ...)

\method{dim}{grid.par}(x)

\method{dimnames}{grid.par}(x)

\method{as.data.frame}{grid.par}(x, row.names = dimnames(x),
  optional = FALSE, ...)

is.data.grid(x)

\method{dim}{data.grid}(x)

\method{dimnames}{data.grid}(x)

splot.plt(horizontal = FALSE, legend.shrink = 0.9, legend.width = 1,
  legend.mar = ifelse(horizontal, 3.1, 5.1), bigplot = NULL,
  smallplot = NULL)

.rev.colorRampPalette(colors, interpolate = "spline", ...)
}
\arguments{
\item{cov.bin}{(optional) covariance matrix of the binned data or semivariogram model
(\code{\link{svarmod}}-class) of the (unbinned) data.}
}
\value{
\code{.compute.masked} returns a list with components:
\item{mask}{logical vector \code{bin$binw > tol.mask}.}
\item{w}{\code{x$binw[mask]}.}
\item{sw}{\code{sum(w)}.}
\item{hat}{(optional) \code{bin$locpol$hat[mask, mask]}.}
\item{cov.bin}{(optional) masked (aproximated) covariance matrix of the binned data.}
}
\description{
Listed below are supporting functions for the major methods in npsp.
}
\keyword{internal}

