% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allotest.R
\name{allotest}
\alias{allotest}
\title{Bootstrap based test for testing an allometric model}
\usage{
allotest(formula, data, na.action = "na.omit", nboot = 500, seed = NULL,
  cluster = TRUE, ncores = NULL, test = "res", ...)
}
\arguments{
\item{formula}{An object of class \code{formula}: a sympbolic description
of the model to be fitted.}

\item{data}{An optional data frame, matrix or list required by 
the formula. If not found in data, the variables are taken from 
\code{environment(formula)}, typically the environment from which
 \code{allotest} is called.}

\item{na.action}{A function which indicates what should happen when the 
data contain 'NA's. The default is 'na.omit'.}

\item{nboot}{Number of bootstrap repeats.}

\item{seed}{Seed to be used in the bootstrap procedure.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the
bootstrap procedure is  parallelized (only for \code{smooth = "splines"}).
 Note that there are cases 
(e.g., a low number of bootstrap repetitions) that R will gain in
performance through serial computation. R takes time to distribute tasks
across the processors also it will need time for binding them all together
later on. Therefore, if the time for distributing and gathering pieces
together is greater than the time need for single-thread computing, it does
not worth parallelize.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores 
to be used is equal to the number of cores of the machine - 1.}

\item{test}{Statistic test to be used, based on residuals on the null model
(\code{res}) or based on the likelihood ratio test 
using rss0 and rss1 \code{lrt}.}

\item{\ldots}{Other options.}
}
\value{
An object is returned with the following elements:
\item{statistic}{the value of the test statistic.}
\item{value}{the p-value of the test.}
}
\description{
Bootstrap-based procedure that tests whether the data 
can be modelled by an allometric model.
}
\details{
In order to facilitate the choice of a model appropriate
to the data while at the same time endeavouring to minimise the 
loss of information,  a bootstrap-based procedure, that test whether the 
data can be modelled by an allometric model, was developed.  Therefore,
\code{allotest} tests the null hypothesis of an allometric model taking 
into account the logarithm of the original variable
 (\eqn{X^* = log(X)} and \eqn{Y^* = log(Y)}). 
 
Based on a general model of the type 
\deqn{Y^*=m(X^*)+\varepsilon}
the aim here is to test the null hypothesis of an allometric model 
\deqn{H_0 = m(x^*) =  a^*+ b^* x^*}
\eqn{vs.} the general hypothesis 
\eqn{H_1}, with \eqn{m}
being an unknown nonparametric function; or analogously,
\deqn{H_1: m(x^*)= a^*+ b^* x^* + g(x^*)}
with \eqn{g(x^*)} being an unknown function not equal to zero. 

To implement this test we have used the wild bootstrap.
}
\examples{
library(npregfast)
data(barnacle)
allotest(DW ~ RC, data = barnacle, nboot = 50, seed = 130853, 
cluster = FALSE)

}
\references{
Sestelo, M. and Roca-Pardinas, J. (2011). A new approach to estimation of 
length-weight relationship of \eqn{Pollicipes}  \eqn{pollicipes} (Gmelin, 1789)
on the Atlantic coast of Galicia (Northwest Spain): some aspects of its 
biology and management. Journal of Shellfish Research, 30 (3), 939--948.

Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.
}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
