% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPedMaxAge.R
\name{getPedMaxAge}
\alias{getPedMaxAge}
\title{Get the maximum age of live animals in the pedigree.}
\usage{
getPedMaxAge(ped)
}
\arguments{
\item{ped}{dataframe with pedigree}
}
\value{
Numeric value representing the maximum age of animals in the
pedigree.
}
\description{
Get the maximum age of live animals in the pedigree.
}
\examples{
library(nprcgenekeepr)
examplePedigree <- nprcgenekeepr::examplePedigree
ped <- qcStudbook(examplePedigree,
  minParentAge = 2,
  reportChanges = FALSE,
  reportErrors = FALSE
)
getPedMaxAge(ped)
}
