% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseAlleles.R
\name{chooseAlleles}
\alias{chooseAlleles}
\title{Combines two vectors of alleles by randomly selecting one allele
or the other at each position.}
\usage{
chooseAlleles(a1, a2)
}
\arguments{
\item{a1}{integer vector with first allele for each individual}

\item{a2}{integer vector with second allele for each individual
\code{a1} and \code{a2} are equal length vectors of alleles for one
individual}
}
\value{
An integer vector with the result of sampling from \code{a1}
and \code{a2} according to Mendelian inheritance.
}
\description{
Combines two vectors of alleles by randomly selecting one allele
or the other at each position.
}
\examples{
chooseAlleles(0L:4L, 5L:9L)
}
