#' Copyright(c) 2017-2020 R. Mark Sharp
#' This file is part of nprcgenekeepr
context("getFocalAnimalPed")

library(stringi)
test_that("getFocalAnimalPed recognizes no file and wrong file arguments", {
  expect_error(getFocalAnimalPed(), "\"fileName\" is missing, with no default")
  expect_error(suppressWarnings(getFocalAnimalPed(
    fileName = "breeding file.csv")), "cannot open the connection")
})

source <- " generated by getFocalAnimalPed: "
qcPed_xlsx <- system.file("testdata", "qcPed.xlsx",
                         package = "nprcgenekeepr")
qcPed_csv <- system.file("testdata", "qcPed.csv",
                         package = "nprcgenekeepr")
qcPed_txt <- system.file("testdata", "qcPed.txt",
                         package = "nprcgenekeepr")
test_that(
  stri_c("getFocalAnimalPed can open an Excel file fails to get ",
         "focal animals"), {
           skip_if_not(Sys.info()[names(Sys.info()) == "user"] == "msharp")
           expect_true(
             stri_detect_fixed(capture.output(tryCatch(
               getFocalAnimalPed(fileName = qcPed_xlsx),
               warning = function(wCond) {
                 cat(paste0("Warning", source, wCond),
                     name = "nprcgenekeepr")
                 return(NULL)
               },
               error = function(eCond) {
                 cat(paste0("Error", source, eCond),
                     name = "nprcgenekeepr")
                 return(NULL)
               }
             ))[[1]], pattern = "Warning generated by getFocalAnimalPed")
           )
         })

test_that(
  stri_c("getFocalAnimalPed can open a CSV file fails to get ",
         "focal animals"),
  {
    skip_if_not(Sys.info()[names(Sys.info()) == "user"] == "msharp")
    expect_true(
      stri_detect_fixed(capture.output(tryCatch(
        getFocalAnimalPed(fileName = qcPed_csv),
        warning = function(wCond) {
          cat(paste0("Warning", source, wCond),
              name = "nprcgenekeepr")
          return(NULL)
        },
        error = function(eCond) {
          cat(paste0("Error", source, eCond),
              name = "nprcgenekeepr")
          return(NULL)
        }
      ))[[1]], pattern = "Warning generated by getFocalAnimalPed")
    )
  })
test_that(
  stri_c("getFocalAnimalPed can open a TXT file fails to get ",
         "focal animals"),
  {
    skip_if_not(Sys.info()[names(Sys.info()) == "user"] == "msharp")
    expect_true(
      stri_detect_fixed(capture.output(tryCatch(
        getFocalAnimalPed(fileName = qcPed_txt),
        warning = function(wCond) {
          cat(paste0("Warning", source, wCond),
              name = "nprcgenekeepr")
          return(NULL)
        },
        error = function(eCond) {
          cat(paste0("Error", source, eCond),
              name = "nprcgenekeepr")
          return(NULL)
        }
      ))[[1]], pattern = "Warning generated by getFocalAnimalPed")
    )
  })
