% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterPairs.R
\name{filterPairs}
\alias{filterPairs}
\title{Filters kinship values from a long-format kinship table based on the sexes
 of the two animals involved.}
\usage{
filterPairs(kin, ped, ignore = list(c("F", "F")))
}
\arguments{
\item{kin}{a dataframe with columns \code{id1}, \code{id2}, and
\code{kinship}. This is the kinship data reformatted from a matrix,
to a long-format table.}

\item{ped}{Dataframe of pedigree information including the IDs listed in
\code{candidates}.}

\item{ignore}{a list containing zero or more character vectors of length 2
indicating which sex pairs should be ignored with regard to kinship.
Defaults to \code{list(c("F", "F"))}.}
}
\value{
A dataframe representing a filtered long-format kinship table.
}
\description{
Part of Group Formation
}
\examples{
\donttest{
library(nprcgenekeepr)
ped <- nprcgenekeepr::lacy1989Ped
ped$gen <- findGeneration(ped$id, ped$sire, ped$dam)
kmat <- kinship(ped$id, ped$sire, ped$dam, ped$gen)
kin <- kinMatrix2LongForm(kmat, rm.dups = FALSE)
threshold <- 0.1
kin <- filterThreshold(kin, threshold = threshold)
ped$sex <- c("M", "F", "M", "M", "F", "F", "M")
kinNull <- filterPairs(kin, ped, ignore = NULL)
kinMM <- filterPairs(kin, ped, ignore = list(c("M", "M")))
ped
kin[kin$id1 == "C", ]
kinMM[kinMM$id1 == "C", ]
}

}
