% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillGroupMembersWithSexRatio.R
\name{fillGroupMembersWithSexRatio}
\alias{fillGroupMembersWithSexRatio}
\title{Forms breeding group(s) with an effort to match a specified sex ratio}
\usage{
fillGroupMembersWithSexRatio(
  candidates,
  groupMembers,
  grpNum,
  kin,
  ped,
  minAge,
  numGp,
  sexRatio
)
}
\arguments{
\item{candidates}{character vector of IDs of the animals available for
use in the group.}

\item{groupMembers}{list initialized and ready to receive groups with the
desired sex ratios that are created within this function}

\item{grpNum}{is a list \code{numGp} long with each member an integer
vector of \code{1:numGp}.}

\item{kin}{list of animals and those animals who are related above a
threshold value.}

\item{ped}{dataframe that is the `Pedigree`. It contains pedigree
information including the IDs listed in \code{candidates}.}

\item{minAge}{integer value indicating the minimum age to consider in group
formation. Pairwise kinships involving an animal of this age or younger will
 be ignored. Default is 1 year.}

\item{numGp}{integer value indicating the number of groups that should be
formed from the list of IDs. Default is 1.}

\item{sexRatio}{numeric value indicating the ratio of females to males x
from 0.5 to 20 by increments of 0.5.}
}
\description{
The sex ratio is the ratio of females to males.
}
