% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npde.R
\docType{data}
\name{warfarin}
\alias{warfarin}
\alias{simwarfarinBase}
\alias{simwarfarinCov}
\title{Pharmacokinetics of warfarin}
\format{
This data frame contains the following columns: 
\describe{
\item{id}{an integer identifying the subject on whom the observation was made}
\item{time}{time since drug administration when the sample was drawn (hr)}
\item{amt}{total dose received by the subject (mg)}
\item{dv}{warfarin concentration in the sample (mg/L)} 
\item{dvid}{observation type (1 for all observations)}
\item{wt}{weight of the subject (kg)} 
\item{sex}{subject gender (0=female, 1=male)} 
\item{age}{age of the subject (yr) } 
}
}
\source{
O’Reilly (1968). Studies on coumarin anticoagulant drugs. Initiation 
of warfarin therapy without a loading dose. Circulation 1968, 38:169-177.
}
\usage{
warfarin
}
\description{
The \code{warfarin} data frame has 251 rows and 8 columns of data containing
data on the pharmacokinetics of warfarin, an anticoagulant drug used in the 
prevention of thrombosis and thromboembolism.
}
\details{
The dataset is the PK part of a larger dataset including both warfarin concentrations
and prothrombin complex activity (PCA), which measures the decreased coagulation 
activity resulting from the inhibition of vitamin K recycling, the mechanism of 
action of warfarin. It contains the concentrations measured in 32 healthy subjects 
after a single oral dose of warfarin sodium (1.5 mg/kg of body weight). The subjects 
in the study were sampled at different times over a period of up to 120 hours.

The data is distributed with the Monolix software as a demo for PK/PD modelling.
The data has been slightly reformated for R, removing the line at time=0
and filling the amt column with the dose for each subject, following the output
of simulx which was used to simulate data from two alternative models to fit this
dataset.

Two datasets containing simulated data are associated with the \code{warfarin} data. For
each dataset, 1000 simulations of the original data were performed for the computation of npde.
The package contains only the simulated data simwarfarinCov because of size constraints. simwarfarinBase can be downloaded from
the github for npde3.0: \url{https://github.com/ecomets/npde30/blob/main/keep/data/simwarfarinBase.tab}
\describe{
\item{simwarfarinBase}{the data in this dataset was simulated according to a base model without covariates: the PK model was a two-compartment model, with first-order absorption and a time-delay. Interindividual variability was modelled as log-normal distributions for parameters Tlag, ka, Cl and V1, and the error model was a combined error model. The parameters were estimated by Monolix.}
\item{simwarfarinCov}{the data in this dataset was simulated according to a model including several covariates: an age (centered on 30 yr) effect on Cl, a weight (centered on 70 kg) effect on Cl and V1, and a gender effect on V1. The covariate model was built in Monolix.}
}
}
\examples{
data(warfarin)

#Plotting the warfarin PK data
plot(dv~time,data=warfarin,xlab="Time after dose (hr)",
ylab="Warfarin concentration (mg/L)")

}
\references{
PDF documentation for npde 3.0: \url{https://github.com/ecomets/npde30/blob/main/userguide_npde_3.0.pdf}
}
\keyword{datasets}
