% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNpde-binningPI.R
\name{npde.binning}
\alias{npde.binning}
\title{Internal functions used to produce prediction intervals}
\usage{
npde.binning(xvec, plot.opt, verbose = FALSE)
}
\arguments{
\item{xvec}{a vector of values for the X-axis of the plot}

\item{plot.opt}{graphical options}

\item{verbose}{boolean (defaults to FALSE). If TRUE, a table showing how the binning was performed}
}
\value{
a list with 2 elements, xgrp (the number of the bin associated with each element of xvec) and xcent (a named vector containing the mean of the elements of xvec contained in each bin; the name of the bin is the interval).
If verbose is TRUE, a table showing the bins is shown, giving the interval of xvec associated with each bin, the mean value
of xvec in each bin, and the number of observations
}
\description{
Functions used by plot functions to define the boundaries of the bins on the X-axis
}
\details{
These functions are normally not called by the end-user.
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.
Mentre. Metrics for external model evaluation with an application to the
population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research},
23:2036--49, 2006.
}
\seealso{
\code{\link{npde}}, \code{\link{autonpde}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{internal}
