% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_nosoiSummary.R
\name{getR0}
\alias{getR0}
\title{Gets R0 from a \code{nosoi} simulation}
\usage{
getR0(nosoi.output)
}
\arguments{
\item{nosoi.output}{Output of a nosoi simulation (object of class \code{\link{nosoiSim}}).}
}
\value{
A list with the following items:
\describe{
   \item{N.inactive}{Number of inactive hosts at the end of the simulation.}
   \item{R0.mean}{Mean R0 based on the distribution (see below).}
   \item{R0.dist}{Distribution for each host of the secondary cases it generated (in case of dual-hosts, then the secondary cases of the same host-type).}
   }
}
\description{
Gets an estimate of secondary cases (what R0 usually tries to estimate) and its distribution from the output of a \code{nosoiSim} simulation. The actual calculation is based on inactive hosts at the end of the simulation to avoid bias introduced by hosts that have not finished their transmission potential.
}
\seealso{
\code{\link{summary.nosoiSim}}
}
