\name{plotgroup}
\alias{plotgroup}

\title{
Barplot of m/z isotope (and optional adduct) relations within an isotope pattern group.
}
\description{
Plots the m/z isotope relations among peaks part of an isotope pattern group detected by \code{\link[nontarget]{pattern.search}}.
Optionally, adduct relations from \code{\link[nontarget]{adduct.search}} can be depicted, too.
}
\usage{
plotgroup(pattern, adduct = FALSE, groupID, massrange = 10, allmass = TRUE)
}

\arguments{
  \item{pattern}{
	List of type pattern, i.e. value generated by \code{\link[nontarget]{pattern.search}}.
}
  \item{adduct}{
	List of type pattern, i.e. value generated by \code{\link[nontarget]{pattern.search}}. If not used, set to \code{FALSE}.
}
  \item{groupID}{
	Isotope pattern group ID of the isotope pattern group to be plotted. Group ID as generated by \code{\link[nontarget]{pattern.search}}.
}
  \item{massrange}{
	m/z range of other peaks in the HRMS peaks in the data set below and above the smallest and largest m/z of the isotope pattern group to be plotted, respectively.
}
  \item{allmass}{
	Prints only the peaks in the isotope pattern (\code{allmass=FALSE}) or also those included via argument massrange (\code{allmass=TRUE}).
}
}
\details{
The upper pannel barplot shows all peaks included by massrange. The lower one only those of the isotope pattern group specified by argument \code{groupID}.
Below that, shown by lines, come the isotope relations among peaks. At the bottom, relations of individual peaks in the isotope pattern group to adduct groups
are highlighted, as far as available. Herein, \code{this adduct} refers to the adduct assigned to the isotope pattern group, whereas \code{further adducts} to those of other peaks
relatable via adduct groups. \code{Peak number} refers to the line number of the peak dataframe printed (see value). 
}

\value{
Dataframe with peaks, see argument \code{allmass}.
}
\author{
Martin Loos
}

\seealso{
	\code{\link[nontarget]{pattern.search}}
	\code{\link[nontarget]{adduct.search}}	
}
\examples{
\donttest{
#############################################################
data(peaklist);
data(adduct_list);
data(iso_list);
# run isotope grouping ######################################
iso<-make.isos(iso_list,charges=c(1),
	elements=c("C","Cl","Br","N","S","K"),
	rm.isotopes=c("33S","36S","40K"),rm.charges=c(1,1,1));
	
pattern<-pattern.search(
  peaklist,
  iso,
  cutint=10000,
  rttol=c(-0.05,0.05),
  mztol=2,
  mzfrac=0.1,
  ppm=TRUE,
  inttol=0.2,
  rules=c(TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,TRUE),
  deter=FALSE,
  entry=50
);
plotgroup(pattern,adduct=FALSE,groupID=3,massrange=10,allmass=FALSE)
# run adduct grouping #######################################
adduct<-adduct.search(
  peaklist,
  adduct_list,
  rttol=0.05,
  mztol=3,
  massfrac=0.1,
  ppm=TRUE,
  adducts=c("M+K","M+H","M+Na","M+NH4"),
  ion_mode="positive",
  entry=50
);
plotgroup(pattern,adduct,groupID=3,massrange=10,allmass=FALSE)
#############################################################
}
}
