## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(nomiShape)

## ----shape-aic-example-1------------------------------------------------------
# Example usage of shape_aic
shape_aic(categories, "animal")

## ----shape-aic-example-2------------------------------------------------------
# Example usage of shape_aic
shape_aic(categories2, "animal")

## ----shape-aic-example-3------------------------------------------------------
# Example usage of shape_aic
shape_aic(categories3, "animal")

## ----shape-aic-example-4------------------------------------------------------
# Example usage of shape_aic
shape_aic(starwars, "species")

## -----------------------------------------------------------------------------
# approximate rate from top counts
obs <- sort(table(starwars$species), decreasing = TRUE)
ranks <- seq_along(obs)
rate_est <- -coef(lm(log(obs + 1e-6) ~ ranks))[2]  # linear fit in log-space
rate_est

## -----------------------------------------------------------------------------
shape_aic(starwars, "species")

## -----------------------------------------------------------------------------
shape_aic (starwars,"species") 

## -----------------------------------------------------------------------------
shape_aic (mpg,"manufacturer") 

