% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collective.R
\name{collective}
\alias{collective}
\alias{nom_coll}
\title{Convert numbers to collective character vectors (the, both, all three)}
\usage{
collective(x, all_n = TRUE, of_the = FALSE, cardinal = TRUE, ...)

nom_coll(x, all_n = TRUE, of_the = FALSE, cardinal = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{all_n}{Whether to include the cardinal number after "all" for
collectives of 3 or more.
Defaults to \code{TRUE}.}

\item{of_the}{Whether to include "of the" for collectives other than 1.
Defaults to \code{FALSE}.}

\item{cardinal}{Whether to convert the number after "all" with \code{\link[=cardinal]{cardinal()}}
when \code{all_n} is \code{TRUE}.
Defaults to \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link[=cardinal]{cardinal()}} when \code{cardinal}
is \code{TRUE}.}
}
\value{
A character vector of the same length as \code{x}.
}
\description{
Convert numbers to collective character vectors (the, both, all three)
}
\examples{
paste(nom_coll(0:3), "fish")
paste(nom_coll(9:12, max_n = 10), "fish")
}
\seealso{
Other number names: 
\code{\link{adverbial}()},
\code{\link{cardinal}()},
\code{\link{denominator}()},
\code{\link{numerator}()},
\code{\link{ordinal}()},
\code{\link{ratio}()}
}
\concept{number names}
