% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_marginal_models.R
\name{estimate_marginal_models}
\alias{estimate_marginal_models}
\title{estimate the marginal likelihood of the relaxed and strict clock model for
a provided alignment}
\usage{
estimate_marginal_models(
  fasta_filename,
  use_yule_prior = FALSE,
  rng_seed = 42,
  sub_rate = 1,
  verbose = FALSE
)
}
\arguments{
\item{fasta_filename}{file name of fasta file holding alignment for which the
marginal likelihood is to be estimated}

\item{use_yule_prior}{by default, a birth-death prior is used as tree prior,
but if use_yule_prior is set to TRUE, a pure-birth prior will be used.}

\item{rng_seed}{seed of pseudo-random number generator}

\item{sub_rate}{substitution rate}

\item{verbose}{boolean indicating if verbose intermediate output is to be
generated}
}
\value{
data frame with marginal likelihoods and relative weights per clock
model.
}
\description{
estimate_marginal_models estimates the marginal likelihood of
both the strict and the relaxed clock model, given the JC69 substitution
model, using the NS package in BEAST, made available via the babette R
package. The NS package performs nested sampling, and uses an MCMC approach
to estimate the marginal likelihood. Sampling is performed until convergence
of the MCMC chain. Unfortunately, currently the babette package is unavailable
on CRAN, requiring installation through GitHub to enjoy the full
functionality of this function.
}
