% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_derived_products.R
\name{query_derived_products}
\alias{query_derived_products}
\title{Query Data From NOAA's CO-OPS Derived Product API}
\usage{
query_derived_products(
  station_id = NULL,
  product_name = NULL,
  year = NULL,
  affil = NULL,
  units = "english"
)
}
\arguments{
\item{station_id}{an optional string that provides the a 7 character station
id. If omitted the derived product API returns data for all stations.}

\item{product_name}{a string providing the name of the derived data product.
Derived products include Top Ten Water Levels (\code{'toptenwaterlevels'}),
Annual Flood Days (\code{'annualflooddays'}), Extreme Water Levels
(\code{'extremewaterlevels'}) and Sea Level Trends (\code{'sealeveltrends'}).}

\item{year}{an optional string used to limit the results from the annual
flood days product to the indicated year. The argument is ignored if used
with other data products.}

\item{affil}{an optional argument used to limit the results from the Sea Level
Trends product to U.S. (\code{'US'}) or Global stations (\code{'Global'}).
If omitted with Sea Level Trends all stations are returned. The argument is
ignored if used with other data products.}

\item{units}{a character string specifying if the data should be returned
using metric or English units. Defaults to \code{'english'}}
}
\value{
a data frame. See the documentation for the specific product
for the details an it's content.
}
\description{
Provides access to data available from NOAA's CO-OPS \href{https://tidesandcurrents.noaa.gov/dpapi/latest/#intro}{Derived Product API}. Four derived data products are available through the API: 1) Top Ten Water Levels, 2) Annual Flood Days, 3) Extreme Water Levels and 4) Sea Level Trends.  More detail about each data product is available with the \href{https://tidesandcurrents.noaa.gov/dpapi/latest/#intro}{API's documentation}
}
\details{
Results are returned as a data frame specific to each product. For the variables
returned with each endpoint see the appropriate section in the documentation.

\itemize{
   \item \href{https://tidesandcurrents.noaa.gov/dpapi/latest/#toptenwls}{Top Ten Water Levels}
   \item \href{https://tidesandcurrents.noaa.gov/dpapi/latest/#annualflooddays}{Annual Flood Days}
   \item \href{https://tidesandcurrents.noaa.gov/dpapi/latest/#extremewaterlevels}{Extreme Water Levels}
   \item \href{https://tidesandcurrents.noaa.gov/dpapi/latest/#sealvltrends}{Sea Level Trends}
}
}
\examples{
\donttest{
# Not Run
query_derived_products(station_id = "1611400",
                       product_name = "sealeveltrends")
}
}
