% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{prob.nnct}
\alias{prob.nnct}
\title{Probability of the current nearest neighbor contingency table}
\usage{
prob.nnct(ct)
}
\arguments{
\item{ct}{A NNCT}
}
\value{
The probability of getting the observed NNCT, \code{ct} , under the null hypothesis.
}
\description{
Computes the probability of the observed \eqn{2 \times 2} nearest neighbor contingency table (NNCT) 
\eqn{p_t=f(n_{11}|n_1,n_2,c_1;\theta)} where \eqn{\theta=(n_1-1)(n_2-1)/(n_1 n_2)} which is the odds ratio
under RL or CSR independence and
\eqn{f} is the probability mass function of the hypergeometric distribution.
That is, given the margins of the current NNCT, the probability of obtaining the current table with the odds
ratio \eqn{\theta} being the value under the null hypothesis.
This value is used to compute the table-inclusive and exclusive \eqn{p}-values for the exact inference on NNCTs.

See (\insertCite{ceyhan:exact-NNCT;textual}{nnspat}) for more details.
}
\examples{
ct<-matrix(sample(20:40,4),ncol=2)
prob.nnct(ct)

ct<-matrix(sample(20:40,4),ncol=2)
prob.nnct(ct)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{exact.pval1s}} and \code{\link{exact.pval2s}}
}
\author{
Elvan Ceyhan
}
