% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_focal.R
\name{raster_focal}
\alias{raster_focal}
\title{Wrapper for \code{raster::focal} on \code{stars} objects}
\usage{
raster_focal(x, w, fun, na.rm = FALSE)
}
\arguments{
\item{x}{A \code{stars} object}

\item{w}{A matrix of weights (the moving window), e.g. a 3 by 3 matrix with values 1}

\item{fun}{A function. The function fun should take multiple numbers, and return a single number}

\item{na.rm}{If \code{TRUE}, \code{NA} will be removed from focal computation. Default is \code{FALSE}}
}
\value{
A \code{stars} object with the filtered output
}
\description{
This is a wrapper around \code{raster::focal}, to apply the function on \code{stars} objects without needing to convert to and from a \code{Raster*} object.
}
\examples{
library(stars)
tif = system.file("tif/L7_ETMs.tif", package = "stars")
r = read_stars(tif)
r = r[, , , 1:2]
w = matrix(1, ncol = 7, nrow = 7)
r_focalmean7 = raster_focal(r, w, mean)
plot(r)
plot(r_focalmean7)

}
