% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_figures.R
\name{fetch_fdim}
\alias{fetch_fdim}
\title{Gets Figure Dimensions}
\usage{
fetch_fdim(obnd = NULL, fid = NULL, fdim = "width", rptdetails = NULL)
}
\arguments{
\item{obnd}{onbrand report object to have report elements appended to}

\item{fid}{Figure ID used in the figures section of the yaml file}

\item{fdim}{Dimension to fetch either "width" or "height"}

\item{rptdetails}{Object creating when reading in rptyaml file}
}
\value{
ggplot object
}
\description{
For a given figure id and report type this will pull out the
dimensions of the figure.
}
\examples{
library(onbrand)  
obnd = read_template(
 template = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.pptx"),
 mapping  = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.yaml"))

# This will create an example fit object to use in the examples below
fit = fetch_fit_example()

# This reads in the report details as well
rptdetails = yaml_read_fit(
 obnd    = obnd,
 rptyaml = system.file(package="nlmixr2rpt", "examples", "report_fit_test.yaml"),
 fit     = fit)$rptdetails

fetch_fdim(obnd=obnd, fid="bad_figure", fdim="width", rptdetails=rptdetails)

fetch_fdim(obnd=obnd, fid="bad_figure", fdim="height", rptdetails=rptdetails)
}
