% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rptnlmixr.R
\name{report_fit}
\alias{report_fit}
\title{Report \code{nlmixr2} Fit Results to PowerPoint and Word}
\usage{
report_fit(
  obnd = NULL,
  fit = NULL,
  placeholders = NULL,
  cat_covars = NULL,
  cont_covars = NULL,
  parameters = NULL,
  rptyaml = system.file(package = "nlmixr2rpt", "templates", "report_fit.yaml"),
  verbose = FALSE
)
}
\arguments{
\item{obnd}{onbrand report object to have report elements appended to.}

\item{fit}{nlmixr2 fit object to be reported.}

\item{placeholders}{Manual placeholders, see \code{\link{yaml_read_fit}} for more.}

\item{cat_covars}{character vector of categorical covariates to overwrite defaults in yaml file.}

\item{cont_covars}{character vector of continuous covariates to overwrite defaults in yaml file.}

\item{parameters}{list with element names for each parameter to overwrite defaults in yaml file.}

\item{rptyaml}{yaml file containing the report elements and structure.}

\item{verbose}{Boolean variable when set to TRUE messages will be .}
}
\value{
onbrand object with the report elements added.
}
\description{
Appends \code{nlmixr2} fit results to an onbrand report object with the
content and format of the report in the supplied yaml file
}
\examples{
\donttest{
library(onbrand)  
obnd = read_template(
 template = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.pptx"),
 mapping  = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.yaml"))

# This will create an example fit object to use in the examples below
fit = fetch_fit_example()

# Appening fit results
obnd_pptx = report_fit(
 fit     = fit, 
 rptyaml = system.file(package="nlmixr2rpt", "examples", "report_fit_test.yaml"),
 obnd    = obnd)

# Writing the report to a file
save_report(obnd, file.path(tempdir(), "report.pptx"))
}
}
