% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_build.R
\name{buildMCMC}
\alias{buildMCMC}
\title{Create an MCMC function, from an MCMCconf object}
\usage{
buildMCMC(conf, ...)
}
\arguments{
\item{conf}{An object of class MCMCconf that specifies the model, samplers, monitors, and thinning intervals for the resulting MCMC function.  See \code{configureMCMC} for details of creating MCMCconf objects.  Alternatively, \code{MCMCconf} may a NIMBLE model object, in which case an MCMC function corresponding to the default MCMC configuration for this model is returned.}

\item{...}{Additional arguments to be passed to \code{configureMCMC} if \code{conf} is a NIMBLE model object}
}
\description{
Accepts a single required argument, which may be of class MCMCconf, or inherit from class modelBaseClass (a NIMBLE model object).  Returns an MCMC function; see details section.
}
\details{
Calling buildMCMC(conf) will produce an uncompiled (R) R mcmc function object, say 'Rmcmc'.

The uncompiled MCMC function will have arguments:

\code{niter}: The number of iterations to run the MCMC.

\code{reset}: Boolean specifying whether to reset the internal MCMC sampling algorithms to their initial state (in terms of self-adapting tuning parameters), and begin recording posterior sample chains anew. Specifying \code{reset=FALSE} allows the MCMC algorithm to continue running from where it left off, appending additional posterior samples to the already existing sample chains. Generally, \code{reset=FALSE} should only be used when the MCMC has already been run (default = TRUE).

\code{simulateAll}: Boolean specifying whether to simulate into all stochastic nodes.  This will overwrite the current values in all stochastic nodes (default = FALSE).

\code{time}: Boolean specifying whether to record runtimes of the individual internal MCMC samplers.  When \code{time=TRUE}, a vector of runtimes (measured in seconds) can be extracted from the MCMC using the method \code{mcmc$getTimes()} (default = FALSE).

\code{progressBar}: Boolean specifying whether to display a progress bar during MCMC execution (default = TRUE).  The progress bar can be permanently disabled by setting the system option \code{nimbleOptions(MCMCprogressBar = FALSE)}.

Samples corresponding to the \code{monitors} and \code{monitors2} from the MCMCconf are stored into the interval variables \code{mvSamples} and \code{mvSamples2}, respectively.
These may be accessed and converted into R matrix objects via:
\code{as.matrix(mcmc$mvSamples)}
\code{as.matrix(mcmc$mvSamples2)}

The uncompiled (R) MCMC function may be compiled to a compiled MCMC object, taking care to compile in the same project as the R model object, using:
\code{Cmcmc <- compileNimble(Rmcmc, project=Rmodel)}

The compiled function will function identically to the uncompiled object, except acting on the compiled model object.
}
\section{Calculating WAIC}{

After the MCMC has been run, calling the \code{calculateWAIC()} method of the MCMC object will return the WAIC for the model, calculated using the posterior samples from the MCMC run.

\code{calculateWAIC()} has a single arugment:

\code{burnIn}: The number of iterations to subtract from the beginning of the posterior samples of the MCMC object for WAIC calculation.  Defaults to 0.

The \code{calculateWAIC} method calculates the WAIC of the model that the MCMC was performed on. The WAIC (Watanabe, 2010) is calculated from Equations 5, 12, and 13 in Gelman (2014).  Note that the set of all parameters monitored by the mcmc object will be treated as \eqn{theta} for the purposes of e.g. Equation 5 from Gelman (2014).  All parameters downstream of the monitored parameters that are necessary to calculate \eqn{p(y|theta)} will be simulated from the posterior samples of \eqn{theta}.
}
\examples{
\dontrun{
code <- nimbleCode({
    mu ~ dnorm(0, 1)
    x ~ dnorm(mu, 1)
})
Rmodel <- nimbleModel(code)
conf <- configureMCMC(Rmodel)
Rmcmc <- buildMCMC(conf)
Cmodel <- compileNimble(Rmodel)
Cmcmc <- compileNimble(Rmcmc, project=Rmodel)
Cmcmc$run(10000)
samples <- as.matrix(Cmcmc$mvSamples)
head(samples)
WAIC <- Cmcmc$calculateWAIC(burnIn = 1000)
}
}
\author{
Daniel Turek
}

