% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAR.R
\name{carMinBound}
\alias{carMinBound}
\title{Calculate the lower bound for the autocorrelation parameter of the \code{dcar_proper} distribution}
\usage{
carMinBound(C, adj, num, M)
}
\arguments{
\item{C}{vector of the same length as \code{adj}, giving the normalized weights associated with each pair of neighboring locations.}

\item{adj}{vector of indices of the adjacent locations (neighbors) of each spatial location.  This is a sparse representation of the full adjacency matrix.}

\item{num}{vector giving the number of neighboring locations of each spatial location, with length equal to the number of locations.}

\item{M}{vector giving the diagonal elements of the conditional variance matrix, with length equal to the number of locations.}
}
\value{
The lower bound (minimum allowable value) for the \code{gamma} parameter of the \code{dcar_proper} distribution.
}
\description{
Calculate the lower bound for the \code{gamma} parameter of the \code{dcar_proper} distribution
}
\details{
Bounds for \code{gamma} are the inverse of the minimum and maximum eigenvalues of: \eqn{M^(-0.5) C M^(0.5)}.
}
\author{
Daniel Turek
}
\seealso{
\code{\link{CAR-Proper}}, \code{\link{carMaxBound}}, \code{\link{carBounds}}
}

