% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{nimbleOptions}
\alias{nimbleOptions}
\title{NIMBLE Options Settings}
\usage{
nimbleOptions(...)
}
\arguments{
\item{...}{any options to be defined as one or more \code{name = value} pairs
or as a single \code{list} of \code{name=value} pairs.}
}
\value{
When invoked with no arguments, returns a list with the current values of all options.
When invoked with one or more arguments, returns a list of the the updated options with their updated values.
}
\description{
Allow the user to set and examine a variety of global _options_
that affect the way in which NIMBLE operates. Call \code{nimbleOptions()}
with no arguments to see a list of available opions.
}
\details{
\code{nimbleOptions} mimics \code{options}. Invoking
\code{nimbleOptions()} with no arguments returns a list with the
  current values of the options.  To access the value of a single option,
   one should use \code{getNimbleOption()}.
}
\examples{
# Set one option:
nimbleOptions(verifyConjugatePosteriors = FALSE)

# Compactly print all options:
str(nimbleOptions(), max.level = 1)

# Save-and-restore options:
old <- nimbleOptions()                    # Saves old options.
nimbleOptions(showCompilerOutput = TRUE,
              verboseErrors = TRUE)       # Sets temporary options.
# ...do stuff...
nimbleOptions(old)                        # Restores old options.
}
\author{
Christopher Paciorek
}

