% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC_configuration.R
\docType{class}
\name{samplerAssignmentRules-class}
\alias{addRule}
\alias{printRules}
\alias{reorder}
\alias{samplerAssignmentRules}
\alias{samplerAssignmentRules-class}
\title{Class \code{samplerAssignmentRules}}
\description{
Objects of this class specify an ordered set of rules for assigning MCMC sampling algorithms to the stochastic nodes in a BUGS model.
This feature can be enabled by setting \code{nimbleOptions(MCMCuseSamplerAssignmentRules = TRUE)}.
The rules can be modified to alter under what circumstances various samplers are assigned, and with what precedence.
When assigning samplers to each stochastic node, the set of rules is traversed beginning with the first, until a matching rule is found.
When a matching rule is found, the sampler specified by that rule is assigned (or general code for sampler assignment is executed),
and the assignment process proceeds to the next stochastic node.  That is, a maximum of one rule can be invoked for each stochastic node.
If no matching rule is found, an (optional) warning is issued and no sampler is assigned.
Objects of this class may be passed using the \code{rules} argument to \code{\link{configureMCMC}} to customize the sampler assignment process.
See documentation below for method \code{initialize()} for details of creating a samplerAssignmentRules object, 
and methods \code{addRule()} and \code{reorder()} for adding and modifying the sampler assignment rules.
The default behaviour of \code{\link{configureMCMC}} can be modified by setting the nimble option \'MCMCsamplerAssignmentRules\' to a customized samplerAssignmentRules object.
The default behaviour of \code{\link{configureMCMC}} can be restored using \code{nimbleOptions(MCMCdefaultSamplerAssignmentRules = samplerAssignmentRules())}.
}
\section{Methods}{

\describe{
\item{\code{addRule(condition, sampler, position, name, print = FALSE)}}{Add a new rule for assigning sampler(s) to the samplerAssignmentRules object.  A rule consists of two parts: (1) a 'condition' which determines when the rule is invoked, and (2) a 'sampler' which governs the assignment of sampler(s) when the rule is invoked.  New rules can be inserted at an arbitrary position in the ordered set of rules.

Arguments:

condition: The 'condition' argument must be a quoted R expression object, which will be evaluated and interpreted as a logical to control whether or not the rule is invoked.  The condition will be evaluated in an environment which contains the BUGS 'model' object, the 'node' name to which the rules (and hence the sampler assignment process) are being applied, and other sampler assignment related arguments of configureMCMC() (e.g., 'useConjugacy' and 'multivariateNodesAsScalars').  Thus, the condition expression may involve these names, as well as methods of BUGS model objects.  Creating an R expression object will generally use the function quote(...).  For example: addRule(condition = quote(model$isBinary(node)), ...).  Model-specific rules for particular nodes could be specified as: addRule(condition = quote(node == 'x' || node == 'y'), ...), or addRule(condition = quote(grepl('^sigma', node)), ...).  Rules for specific distributions can be created as: addRule(condition = quote(model

sampler: The 'sampler' argument controls the sampler assignment process, once a rule is invoked (i.e., the 'condition' evaluated to TRUE).  The 'sampler' argument must take one of three different forms: (1) a character string giving the name of an MCMC nimbleFunction sampler, (2) an unspecialized nimbleFunction object which is a valid MCMC sampler, or (3) an arbitrary quoted R expression object, which will be executed to perform the sampler assignment process, and should generally make use of the method addSampler().  Example (1): addRule(..., sampler = 'slice'), for assigning a 'slice' sampler when the rule is invoked. Example (2): addRule(..., sampler = my_sampler_nimbleFunction), for assigning the sampling algorithm defined in the object my_sampler_nimbleFunction.  Note the same behaviour will result from: addRule(..., sampler = 'my_sampler_nimbleFunction'), which will be also more informative when the list of assignment rules is printed.  Example (3): addRule(..., sampler = quote( 

position: Index of the position to add the new rule.  By default, new rules are added at the end of the current ordered set of rules (giving it the lowest priority in the sampler assignment process).  Specifying a position inserts the new rule at that position, and does not over-write an existing rule.

name: Optional character string name for the sampler to be added, which is used by subsequent print methods.  If 'name' is not provided, the 'sampler' argument is used to generate the name.  Note, if the 'sampler' argument is provided as an R expression making use of the addSampler method, then the 'name' argument will not be passed on to the MCMC configuration object, and instead any call(s) to addSampler can explicitly make use of its own 'name' argument.

print: Logical argument specifying whether to print the newly-added sampler assignment rule (default FALSE).}

\item{\code{initialize(empty = FALSE, print = FALSE)}}{Creates a new samplerAssignmentRules object, which is a container for an ordered set of rules for MCMC sampler assignments.  Objects of this class may be passed using the 'rules' argument to configureMCMC(), to customize the process of assigning samplers to stochastic model nodes.  By default, new samplerAssignmentRules objects are initialized having an exact copy of the default sampler assignment rules used by NIMBLE, and can thereafter be modified using the addRule() and reorder() methods.

Arguments:

empty: Logical argument (default = FALSE).  If TRUE, then a new samplerAssignmentRules object is created containing no rules.  The default behaviour creates new objects containing an exact copy of the default sampler assignment rules used by NIMBLE.

print: Logical argument specifying whether to print the ordered list of sampler assignment rules (default FALSE).}

\item{\code{printRules(ind)}}{Prints the ordered set of sampler assignment rules.

Arguments:

ind: A set of indicies, specifying which sampler assignment rules to print.  If omitted, all rules are printed.}

\item{\code{reorder(ind, print = FALSE)}}{Reorder the current ordered list of sampler assignment rules.  This method can be used to reorder the existing rules, as well as delete one or more rules.

Arguments:

ind: The indices of the current set of rules to keep.  Assuming there are 10 rules, reorder(1:5) will remove the final five rules, reorder(c(10,1:9)) will move the last (lowest priority) rule to the first position (highest priority), and reorder(8) deletes all rules except the eighth, making it the only (and hence first, highest priority) rule.

print: Logical argument specifying whether to print the resulting ordered list of sampler assignment rules (default FALSE).}
}}
\examples{
\dontrun{
## enable the use of samplerAssignmentRules:
nimbleOptions(MCMCuseSamplerAssignmentRules = TRUE)

## omitting empty=TRUE creates a copy of nimble's default rules
my_rules <- samplerAssignmentRules(empty = TRUE)

my_rules$addRule(quote(model$isEndNode(node)), "posterior_predictive")
my_rules$addRule(quote(model$isDiscrete(node)), "my_new_discrete_sampler")
my_rules$addRule(TRUE, "RW")   ## default catch-all sampler assignment

## print the ordered set of sampler assignment rules
my_rules$printRules()

## assign samplers according to my_rules object
conf <- configureMCMC(Rmodel, rules = my_rules)
conf$printSamplers()

## view the current (default) assignment rules used by configureMCMC()
nimbleOptions(MCMCdefaultSamplerAssignmentRules)

## change default behaviour of configureMCMC() to use my_rules
nimbleOptions(MCMCdefaultSamplerAssignmentRules = my_rules)

## reset configureMCMC() to use default rules
nimbleOptions(MCMCdefaultSamplerAssignmentRules = samplerAssignmentRules())
}
}
\author{
Daniel Turek
}
\seealso{
\code{\link{configureMCMC}}
}

