% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\title{Mean Squared Error (MSE)}
\usage{
mse(prediction, outcome)
}
\arguments{
\item{prediction}{A \code{numeric} vector of predictions.}

\item{outcome}{A \code{numeric} vector of outcomes actually observed.}
}
\description{
Easily compute the mean squared error for continuous predictions
}
\examples{
x <- rnorm(100)
y <- x^2
test_x <- rnorm(100)
test_y <- test_x^2
mod <- glm(y ~ x)
pred <- predict(mod, newx = as.data.frame(test_x))
error <- mse(prediction = pred, outcome = test_y)

}
