% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nic_colours.R
\name{nic_palette}
\alias{nic_palette}
\title{NIC Palette Generator.}
\usage{
nic_palette(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of the color palette. Options are \code{applecroton}, \code{colleasa}, \code{colleasb}}

\item{n}{Number of colors in the palette. Palletes include 5-8 colors, which can be used discretely,
or if more are desired, used as a gradient. If omitted, n = length of palette.}

\item{type}{Usage of palette as "continuous" or "discrete". Continuous usage interpolates between colors to create
a scale of values. If omitted, function assumes continuous if n > length of palette, and discrete if n < length of palette.}
}
\value{
A vector of colors.
}
\description{
This function builds palettes based on natural scenes in the Pacific Northwest. Each palette is inspired by the author's nature photography
of the region, and checked for color blind safety using \href{https://gka.github.io/palettes/#/9|s|00429d,96ffea,ffffe0|ffffe0,ff005e,93003a|1|1}{Chroma.js Color Palette Helper}.
View photos for each palette \href{https://github.com/thiyangt/nic}{On Github}.
}
\examples{
nic_palette("applecroton_2",n=100,type="continuous")
nic_palette("coleusa_2",2)
nic_palette("coleusb_3",50)

}
