% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw}
\alias{draw}
\title{Generic function for simulating from NHPPPs given the intensity function
or the cumulative intensity function.}
\usage{
draw(
  lambda = NULL,
  lambda_maj = NULL,
  Lambda = NULL,
  Lambda_inv = NULL,
  range_t = c(0, 10),
  rng_stream = NULL,
  atmost1 = FALSE,
  atleast1 = FALSE
)
}
\arguments{
\item{lambda}{(function) the instantaneous rate of the NHPPP.
A continuous function of time.}

\item{lambda_maj}{(double, vector) the intercept and optional slope of the majorizing
linear (if \code{exp_maj = FALSE}) or log-linear (if \code{exp_maj = TRUE}) function in \code{range_t}.}

\item{Lambda}{(function, double vector) a continuous increasing R to R map
which is the integrated rate of the NHPPP}

\item{Lambda_inv}{(function, double vector) the inverse of \code{Lambda()}}

\item{range_t}{(vector, double) min and max of the time interval.}

\item{rng_stream}{(\code{rstream}) an \code{rstream} object or \code{NULL}}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atleast1}{boolean, draw at least 1 event time in interval}
}
\value{
a vector of event times
}
\description{
This is a wrapper to the package's specific functions, and thus somewhat slower.
For time-intensive simulations prefer one of the specific functions.
}
