% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nldi.R
\name{navigate_nldi}
\alias{navigate_nldi}
\title{Navigate NLDI}
\usage{
navigate_nldi(
  nldi_feature,
  mode = "upstreamMain",
  data_source = "flowlines",
  distance_km = 10,
  tier = "prod"
)
}
\arguments{
\item{nldi_feature}{list with names `featureSource` and `featureID` where
`featureSource` is derived from the "source" column of  the response of
discover_nldi_sources() and the `featureSource` is a known identifier
from the specified `featureSource`.}

\item{mode}{character chosen from names, URLs, or url parameters
returned by discover_nldi_navigation(nldi_feature). See examples.}

\item{data_source}{character chosen from "source" column of the response
of discover_nldi_sources() or empty string for flowline geometry.}

\item{distance_km}{numeric distance in km to stop navigating.}

\item{tier}{character optional "prod" or "test"}
}
\value{
sf data.frame with result
}
\description{
Navigate the Network Linked Data Index network.
}
\examples{
\donttest{
library(sf)
library(dplyr)

nldi_nwis <- list(featureSource = "nwissite", featureID = "USGS-05428500")

navigate_nldi(nldi_feature = nldi_nwis,
              mode = "upstreamTributaries") \%>\%
  st_geometry() \%>\%
  plot()

navigate_nldi(nldi_feature = nldi_nwis,
              mode = "UM") \%>\%
  st_geometry() \%>\%
  plot(col = "blue", add = TRUE)



nwissite <- navigate_nldi(nldi_feature = nldi_nwis,
                          mode = "UT",
                          data_source = "nwissite")

st_geometry(nwissite) \%>\%
  plot(col = "green", add = TRUE)

nwissite
}

}
