% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations_utils.R
\name{nflseedR_compute_results}
\alias{nflseedR_compute_results}
\title{Compute NFL Game Results in Season Simulations}
\usage{
nflseedR_compute_results(teams, games, week_num, ...)
}
\arguments{
\item{teams}{A list of teams by simulation number. This is usually calculated
automatically and not user facing. It can be used to "transport" team information
like elo ratings from one simulated week to the next. Defaults to
\link{sims_teams_example}. Please see this example to understand
the required data structure.}

\item{games}{An NFL schedule where some results are missing. \code{compute_results}
is supposed to compute those results on a weekly base. Defaults to
\link{sims_games_example}. Please see this example to understand
the required data structure.}

\item{week_num}{The week of a NFL season for which the function should
compute results.}

\item{...}{Additional parameters used in the function. It is possible to pass
the argument \code{elo} to the function. This must be a named vector in which the
names correspond to the team abbreviations and the values correspond to the
initial elo ratings, which are then updated after each week based on the
results and transported to the next week.}
}
\value{
A list of updated \code{teams} and \code{games} tables.
}
\description{
This is the default nflseedR function to compute game results in season
simulations.
}
\details{
This function implements a variant of 538's elo model initially coded
by Lee Sharpe (in nflseedR 1.0) and for performance rewritten
by Sebastian Carl (in nflseedR 2.0).
}
\examples{
g <- nflseedR::sims_games_example
# The functions expects the variable "sim" instead of "season"
g$sim <- g$season
t <- nflseedR::sims_teams_example

out <- nflseedR_compute_results(
  teams = t,
  games = g,
  week_num = 5L
)

str(out, max.level = 2)
}
\keyword{internal}
