% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_player_stats.R
\name{load_player_stats}
\alias{load_player_stats}
\title{Load Player Level Weekly Stats}
\usage{
load_player_stats(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[nflreadr:load_player_stats]{nflreadr::load_player_stats}}
  \describe{
    \item{\code{seasons}}{a numeric vector of seasons to return, defaults to most recent season. If set to \code{TRUE}, returns all available data.}
    \item{\code{stat_type}}{one of \code{offense} or \code{kicking}}
    \item{\code{file_type}}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
  }}
}
\value{
A tibble of week-level player statistics that aims to match NFL official box scores.
}
\description{
Load Player Level Weekly Stats
}
\examples{
\donttest{
stats <- load_player_stats()
dplyr::glimpse(stats)
}
}
\seealso{
The function \code{\link[=calculate_player_stats]{calculate_player_stats()}} and the corresponding examples
on \href{https://www.nflfastr.com/articles/nflfastR.html#example-11-replicating-official-stats}{the nflfastR website}
}
